<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>سند صرف عدة قسائم</title>
    <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Cairo:wght@200;300;400;600;700;900&display=swap">
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Poppins:300,400,500,600,700,800">
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Open+Sans:400,600,700">
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Montserrat:400,500,600,700">
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Roboto:400,500,700">
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Nunito:400,600,700">
    <style>
        .invoice-box {
            max-width: 800px;
            margin: auto;
            padding: 30px;
            border: 1px solid #eee;
            box-shadow: 0 0 10px rgb(0 0 0 / 15%);
            font-size: 16px;
            line-height: 24px;
            font-family: 'Cairo', sans-serif;
            color: #555;
            text-align: right;
        }

        .top {
            display: flex;
            flex-direction: row-reverse;
            align-content: center;
            justify-content: space-between;
            font-size: 20px;
            font-weight: bold;
            padding-bottom: 20px;
            border-bottom: 4px solid #193B62;
        }

        .top span:nth-child(1) {
            display: block;
        }

        .top .right {
            display: flex;
            align-items: center;
            flex-direction: column;
            align-content: center;
        }

        .top .center {
            display: flex;
            align-items: center;

        }

        .information {
            display: flex;
            flex-direction: row-reverse;
            align-content: center;
            justify-content: center;
            margin-top: 20px;
            padding-left: 50px;
            padding-right: 50px;
        }



        .information .right {
            display: flex;
            align-items: center;
            flex-direction: row-reverse;
            align-content: center;
        }

        .information .center {
            display: flex;
            align-items: center;
            flex-direction: row-reverse;
            align-content: center;

        }

        .information .left {
            display: flex;
            align-items: center;
            flex-direction: row-reverse;
            align-content: center;

        }

        .information-main {

            margin-top: 30px;
            padding-left: 90px;
            padding-right: 90px;
        }



        .information-main .right {
            display: flex;
            align-items: center;
            flex-direction: row-reverse;
            align-content: center;
        }

        .information-main .left {
            display: flex;
            align-items: center;
            flex-direction: row-reverse;
            align-content: center;

        }

        .left span:nth-child(1) {
            display: block;
        }

        .left span:nth-child(2) {
            display: block;
        }

        span {
            margin-right: 8px;
            font-weight: 500;
        }

        .bold {
            font-weight: bold;
        }

        .botom {
            display: flex;
            flex-direction: row-reverse;
            align-content: center;
            justify-content: space-between;
            margin-top: 40px;
            padding-left: 20px;
            padding-right: 20px;

        }


        .seg2 {
            display: flex;
            flex-direction: row-reverse;
            justify-content: space-between;
        }

        .botom .seg {
            display: flex;
            flex-direction: column;
            align-content: center;

        }

        .botom .center {
            display: flex;
            align-items: center;
            flex-direction: row-reverse;
            align-content: center;

        }

        .botom .left {
            display: flex;
            align-items: center;
            flex-direction: row-reverse;
            align-content: center;

        }

        .botom-seg {
            display: flex;
            flex-direction: row-reverse;
            align-content: center;
            justify-content: space-between;
            margin-top: 10px;
            padding-left: 20px;
            padding-right: 20px;
            margin-bottom: 40px;
        }



        .botom-seg .right {
            display: flex;
            align-items: center;
            flex-direction: row-reverse;
            align-content: center;
        }

        .botom-seg .center {
            display: flex;
            align-items: center;
            flex-direction: row-reverse;
            align-content: center;

        }

        .botom-seg .left {
            display: flex;
            align-items: center;
            flex-direction: row-reverse;
            align-content: center;

        }

        .top-text {
            display: flex;
            margin-bottom: 20px;
            flex-direction: row-reverse;
        }

        .botom-text {
            display: flex;

            flex-direction: row-reverse;
        }

        table,
        th,
        td {
            border: 1px solid black;
            border-collapse: collapse;
            direction: rtl;
            padding: 10px;
            text-align: center;
            margin-top: 20px;
        }

        @media print {
            .invoice-box {
                max-width: unset;
                box-shadow: none;
                border: 0px;
            }
        }

        @page {
            size: A4 
        }
    </style>
</head>

<body>
    <div class="invoice-box">
        <div class="top">
            <div class="left">
                <span>الجمهورية اليمنية</span>
                <span>صنعاء شارع الستين</span>
                <span>+967 773344551</span>
            </div>
            <div class="center">
                <img width="200" src="<?php echo e(asset('/images/logo-full.png')); ?>" alt="">

            </div>
            <div class="right">

                <span class="">رقم السند :
                <?php if(isset($receptId)): ?>
                    <?php echo e($receptId); ?>

                <?php endif; ?></span>
                <span class="">التاريخ :
                    <?php if(isset($dateTime)): ?>
                        <?php echo e(explode(' ',$dateTime)[0]); ?>

                    <?php endif; ?></span>

            </div>

        </div>

        <div class="information">

            <div class="center">
                <span class="bold">سند صرف عدة قسائم</span>

            </div>

        </div>



        <div class="table">
            <table style="width: 100%;">
                <tr style="background: #eee;">
                    <th>رقم القسيمة</th>
                    <th>مصروفة من العميل</th>
                    <th>الكمية</th>
                    <th>النوع</th>
                </tr>
                <?php if(isset($coupons)): ?>
                    <?php $__currentLoopData = $coupons; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $coupon): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php if(isset($coupon->id)): ?>
                                <?php echo e($coupon->id); ?>

                            <?php endif; ?></td>
                            <td><?php if(isset($coupon->clint->name)): ?>
                                <?php echo e($coupon->clint->name); ?>

                            <?php endif; ?></td>
                            <td><?php if(isset($coupon->quantity)): ?>
                                <?php echo e($coupon->quantity); ?>

                            <?php endif; ?></td>
                            <td><?php if(isset($coupon->type)): ?>
                                <?php echo e($fNTT->giveType($coupon->type)); ?>

                            <?php endif; ?></td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>


            </table>
            <h4>اجمالي البترول : <?php if(isset($quantityOfPetrolCoupons)): ?>
                <?php echo e($quantityOfPetrolCoupons); ?>

            <?php endif; ?></h4>
            <h4>اجمالي الديزل : <?php if(isset($quantityOfDieselCoupons)): ?>
                <?php echo e($quantityOfDieselCoupons); ?>

            <?php endif; ?></h4>
        </div>
        <div class="botom">

            <div class="seg">
                <div class="top-text">
                    <span class="bold">: المستلم</span>
                    <span><?php if(isset($beneficiaryName)): ?>
                        <?php echo e($beneficiaryName); ?>

                    <?php endif; ?></span>
                </div>
                <div class="botom-text">
                    <span class="bold">: التوقيع</span>
                    <span>........................</span>
                </div>
            </div>
            <div class="seg">
                <div class="top-text">
                    <span class="bold">: المحاسب</span>
                    <span><?php if(isset($accounterName)): ?>
                        <?php echo e($accounterName); ?> 
                    <?php endif; ?></span>
                </div>

                <div class="botom-text">
                    <span class="bold">: التوقيع</span>
                    <span>........................</span>
                </div>
            </div>
            <div class="seg">
                <div class="top-text">
                    <span class="bold">: المدير</span>
                    <span><?php if(isset($adminName)): ?>
                        <?php echo e($adminName); ?>

                    <?php endif; ?></span>
                </div>

                <div class="botom-text">
                    <span class="bold">: التوقيع</span>
                    <span>........................</span>
                </div>
            </div>
        </div>




    </div>

</body>

</html>
<?php /**PATH C:\Users\Nasser\Desktop\petrol_store\resources\views/coupons/spent-multi-coupons.blade.php ENDPATH**/ ?>